/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.network;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class FirewallRule
implements Serializable {
    static final long serialVersionUID = 3456483652420817883L;
    protected String ifName;
    protected String sourceAddr;
    protected String sourceAddrMask;
    protected String protocol;
    protected String port;
    protected ArrayList additionalPorts;
    public static final String INTERFACE_ALL = "ALL";
    public static final String PROTOCOL_TCP = "tcp";
    public static final String PROTOCOL_UDP = "udp";
    public static final String PROTOCOL_ICMP = "icmp";

    public FirewallRule(String ifName, String sourceAddr, String sourceAddrMask, String protocol, String port) {
        this.ifName = ifName;
        this.sourceAddr = sourceAddr;
        this.sourceAddrMask = sourceAddrMask;
        this.protocol = protocol;
        this.port = port;
        this.additionalPorts = new ArrayList();
    }

    public String getInterfaceName() {
        return this.ifName;
    }

    public String getSourceAddr() {
        return this.sourceAddr;
    }

    public String getSourceAddrMask() {
        return this.sourceAddrMask;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getPort() {
        return this.port;
    }

    public List getAdditionalPorts() {
        if (this.additionalPorts == null) {
            this.additionalPorts = new ArrayList();
        }
        return (ArrayList)this.additionalPorts.clone();
    }

    public void addAdditionalPort(String protocol, String number) {
        if (this.additionalPorts == null) {
            this.additionalPorts = new ArrayList();
        }
        if (!(protocol.equals(PROTOCOL_UDP) || protocol.equals(PROTOCOL_TCP) || protocol.equals(PROTOCOL_ICMP))) {
            throw new IllegalArgumentException("protocol must be udp,tcp or icmp");
        }
        this.additionalPorts.add(protocol + ":" + number);
    }

    public boolean equals(Object o) {
        if (this.additionalPorts == null) {
            this.additionalPorts = new ArrayList();
        }
        boolean answer = false;
        if (o instanceof FirewallRule) {
            FirewallRule rule = (FirewallRule)o;
            boolean bl = answer = this.ifName.equals(rule.ifName) && this.sourceAddr.equals(rule.sourceAddr) && this.sourceAddrMask.equals(rule.sourceAddrMask) && this.protocol.equals(rule.protocol) && this.port.equals(rule.port);
            if (this.additionalPorts != null) {
                answer = answer && this.additionalPorts.equals(rule.additionalPorts);
            }
        }
        return answer;
    }

    public int hashCode() {
        if (this.additionalPorts == null) {
            this.additionalPorts = new ArrayList();
        }
        return this.ifName.hashCode() + this.sourceAddr.hashCode() + this.sourceAddrMask.hashCode() + this.protocol.hashCode() + this.port.hashCode() + this.additionalPorts.hashCode();
    }

    public String toString() {
        return "FirewallRule: Allow on " + this.ifName + " from " + this.sourceAddr + "/" + this.sourceAddrMask + " protocol " + this.protocol + " port " + this.port;
    }
}

